// Generated by CoffeeScript 1.8.0
(function() {
  var BASE_URL, UNICODE_VERSION, UnicodeTrieBuilder, fs, request;

  request = require('request');

  fs = require('fs');

  UnicodeTrieBuilder = require('unicode-trie/builder');

  UNICODE_VERSION = '8.0.0';

  BASE_URL = "http://www.unicode.org/Public/" + UNICODE_VERSION + "/ucd";

  request("" + BASE_URL + "/auxiliary/GraphemeBreakProperty.txt", function(err, res, data) {
    var classes, end, match, nextClass, re, start, trie, type, _ref;
    re = /^([0-9A-F]+)(?:\.\.([0-9A-F]+))?\s*;\s*([A-Za-z_]+)/gm;
    nextClass = 1;
    classes = {
      Other: 0
    };
    trie = new UnicodeTrieBuilder(classes.Other);
    while (match = re.exec(data)) {
      start = match[1];
      end = (_ref = match[2]) != null ? _ref : start;
      type = match[3];
      if (classes[type] == null) {
        classes[type] = nextClass++;
      }
      trie.setRange(parseInt(start, 16), parseInt(end, 16), classes[type]);
    }
    fs.writeFile(__dirname + '/classes.trie', trie.toBuffer());
    return fs.writeFile(__dirname + '/classes.json', JSON.stringify(classes));
  });

}).call(this);
